/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.impl.KongVaultAnimator;
import com.alrex.parcool.client.animation.impl.SpeedVaultAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Vault
extends Action {
    private double stepHeight = 0.0;
    private Vec3 stepDirection = null;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        Vec3 lookVec = player.m_20154_();
        lookVec = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_).m_82541_();
        Vec3 step = WorldUtil.getVaultableStep((LivingEntity)player);
        if (step == null) {
            return false;
        }
        step = step.m_82541_();
        Vec3 dividedVec = new Vec3(lookVec.f_82479_ * step.f_82479_ + lookVec.f_82481_ * step.f_82481_, 0.0, -lookVec.f_82479_ * step.f_82481_ + lookVec.f_82481_ * step.f_82479_).m_82541_();
        if (dividedVec.f_82479_ < 0.707106) {
            return false;
        }
        AnimationType animationType = null;
        SpeedVaultAnimator.Type type = SpeedVaultAnimator.Type.Right;
        switch ((TypeSelectionMode)((Object)ParCoolConfig.CONFIG_CLIENT.vaultAnimationMode.get())) {
            case KongVault: {
                animationType = AnimationType.KongVault;
                break;
            }
            case SpeedVault: {
                animationType = AnimationType.SpeedVault;
                type = dividedVec.f_82481_ > 0.0 ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
                break;
            }
            default: {
                if (dividedVec.f_82479_ > 0.99) {
                    animationType = AnimationType.KongVault;
                    break;
                }
                animationType = AnimationType.SpeedVault;
                type = dividedVec.f_82481_ > 0.0 ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
            }
        }
        double wallHeight = WorldUtil.getWallHeight((LivingEntity)player);
        startInfo.put(animationType.getCode());
        BufferUtil.wrap(startInfo).putBoolean(type == SpeedVaultAnimator.Type.Right);
        startInfo.putDouble(step.f_82479_).putDouble(step.f_82480_).putDouble(step.f_82481_).putDouble(wallHeight);
        return !(!parkourability.getActionInfo().can(Vault.class) || stamina.isExhausted() || (Boolean)ParCoolConfig.CONFIG_CLIENT.vaultNeedKeyPressed.get() != false && !KeyBindings.getKeyVault().m_90857_() || !parkourability.get(FastRun.class).canActWithRunning(player) || stamina.isExhausted() || !player.m_20096_() && (Boolean)ParCoolConfig.CONFIG_CLIENT.disableVaultInAir.get() != false || !(wallHeight > (double)player.m_20206_() * 0.44));
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return this.getDoingTick() < this.getVaultAnimateTime();
    }

    private int getVaultAnimateTime() {
        return 2;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        AnimationType animationType = AnimationType.fromCode(startData.get());
        SpeedVaultAnimator.Type speedVaultType = BufferUtil.getBoolean(startData) ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
        this.stepDirection = new Vec3(startData.getDouble(), startData.getDouble(), startData.getDouble());
        this.stepHeight = startData.getDouble();
        Animation animation = Animation.get(player);
        if (animation != null && animationType != null) {
            switch (animationType) {
                case SpeedVault: {
                    animation.setAnimator(new SpeedVaultAnimator(speedVaultType));
                    break;
                }
                case KongVault: {
                    animation.setAnimator(new KongVaultAnimator());
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        AnimationType animationType = AnimationType.fromCode(startData.get());
        SpeedVaultAnimator.Type speedVaultType = BufferUtil.getBoolean(startData) ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
        Animation animation = Animation.get(player);
        if (animation != null && animationType != null) {
            switch (animationType) {
                case SpeedVault: {
                    animation.setAnimator(new SpeedVaultAnimator(speedVaultType));
                    break;
                }
                case KongVault: {
                    animation.setAnimator(new KongVaultAnimator());
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWorkingTickInLocalClient(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.stepDirection == null) {
            return;
        }
        player.m_20334_(this.stepDirection.m_7096_() / 10.0, (this.stepHeight + 0.02) / (double)this.getVaultAnimateTime() / ((double)player.m_20206_() / 1.8), this.stepDirection.m_7094_() / 10.0);
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStopInLocalClient(Player player) {
        this.stepDirection = this.stepDirection.m_82541_();
        player.m_20334_(this.stepDirection.m_7096_() * 0.45, 0.075 * ((double)player.m_20206_() / 1.8), this.stepDirection.m_7094_() * 0.45);
    }

    public static enum TypeSelectionMode {
        SpeedVault,
        KongVault,
        Dynamic;

    }

    public static enum AnimationType {
        SpeedVault(0),
        KongVault(1);

        private final byte code;

        private AnimationType(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        @Nullable
        public static AnimationType fromCode(byte code) {
            switch (code) {
                case 0: {
                    return SpeedVault;
                }
                case 1: {
                    return KongVault;
                }
            }
            return null;
        }
    }
}

